/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.AttachCapabilitiesEventPart;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartStateBase<P extends IPartType>
implements IPartState<P>,
IDirtyMarkListener {
    private boolean dirty = false;
    private boolean update = false;
    private boolean forceBlockUpdateRender = false;
    private int updateInterval = this.getDefaultUpdateInterval();
    private int priority = 0;
    private int channel = 0;
    private Direction targetSide = null;
    private int id = -1;
    private Map<IAspect, IAspectProperties> aspectProperties = new IdentityHashMap<IAspect, IAspectProperties>();
    private boolean enabled = true;
    private CapabilityDispatcher capabilities = null;
    private IdentityHashMap<Capability<?>, LazyOptional<Object>> volatileCapabilities = new IdentityHashMap();

    @Override
    public void writeToNBT(CompoundTag tag) {
        tag.m_128405_("updateInterval", this.updateInterval);
        tag.m_128405_("priority", this.priority);
        tag.m_128405_("channel", this.channel);
        if (this.targetSide != null) {
            tag.m_128405_("targetSide", this.targetSide.ordinal());
        }
        tag.m_128405_("id", this.id);
        this.writeAspectProperties("aspectProperties", tag);
        tag.m_128379_("enabled", this.enabled);
        if (this.capabilities != null) {
            tag.m_128365_("ForgeCaps", (Tag)this.capabilities.serializeNBT());
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.updateInterval = tag.m_128451_("updateInterval");
        this.priority = tag.m_128451_("priority");
        this.channel = tag.m_128451_("channel");
        if (tag.m_128425_("targetSide", 3)) {
            this.targetSide = Direction.values()[tag.m_128451_("targetSide")];
        }
        this.id = tag.m_128451_("id");
        this.aspectProperties.clear();
        this.readAspectProperties("aspectProperties", tag);
        this.enabled = tag.m_128471_("enabled");
        if (this.capabilities != null && tag.m_128441_("ForgeCaps")) {
            this.capabilities.deserializeNBT(tag.m_128469_("ForgeCaps"));
        }
    }

    protected void writeAspectProperties(String name, CompoundTag tag) {
        CompoundTag mapTag = new CompoundTag();
        ListTag list = new ListTag();
        for (Map.Entry<IAspect, IAspectProperties> entry : this.aspectProperties.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_("key", entry.getKey().getUniqueName().toString());
            if (entry.getValue() != null) {
                entryTag.m_128365_("value", (Tag)entry.getValue().toNBT());
            }
            list.add((Object)entryTag);
        }
        mapTag.m_128365_("map", (Tag)list);
        tag.m_128365_(name, (Tag)mapTag);
    }

    public void readAspectProperties(String name, CompoundTag tag) {
        CompoundTag mapTag = tag.m_128469_(name);
        ListTag list = mapTag.m_128437_("map", 10);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entryTag = list.m_128728_(i);
                IAspect key = Aspects.REGISTRY.getAspect(new ResourceLocation(entryTag.m_128461_("key")));
                AspectProperties value = null;
                if (entryTag.m_128441_("value")) {
                    value = new AspectProperties();
                    value.fromNBT(entryTag.m_128469_("value"));
                }
                if (key == null || value == null) continue;
                this.aspectProperties.put(key, value);
            }
        }
    }

    @Override
    public void generateId() {
        this.id = IntegratedDynamics.globalCounters.getNext("part");
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public void setTargetSideOverride(Direction targetSide) {
        this.targetSide = targetSide;
    }

    @Override
    @Nullable
    public Direction getTargetSideOverride() {
        return this.targetSide;
    }

    @Override
    public boolean isDirtyAndReset() {
        boolean wasDirty = this.dirty;
        this.dirty = false;
        return wasDirty;
    }

    @Override
    public boolean isUpdateAndReset() {
        boolean wasUpdate = this.update;
        this.update = false;
        return wasUpdate;
    }

    @Override
    public void forceBlockRenderUpdate() {
        this.forceBlockUpdateRender = true;
    }

    @Override
    public boolean isForceBlockRenderUpdateAndReset() {
        boolean wasForceBlockUpdateRender = this.forceBlockUpdateRender;
        this.forceBlockUpdateRender = false;
        return wasForceBlockUpdateRender;
    }

    public void onDirty() {
        this.dirty = true;
        this.forceBlockRenderUpdate();
    }

    public void sendUpdate() {
        this.update = true;
    }

    @Override
    public IAspectProperties getAspectProperties(IAspect aspect) {
        return this.aspectProperties.get(aspect);
    }

    @Override
    public void setAspectProperties(IAspect aspect, IAspectProperties properties) {
        this.aspectProperties.put(aspect, properties);
        this.sendUpdate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        if (this.enabled != wasEnabled) {
            this.sendUpdate();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void gatherCapabilities(P partType) {
        AttachCapabilitiesEventPart event = new AttachCapabilitiesEventPart((IPartType)partType, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities(), event.getListeners()) : null;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        LazyOptional<Object> o = this.volatileCapabilities.get(capability);
        if (o != null && o.isPresent()) {
            return o.cast();
        }
        return this.capabilities == null ? LazyOptional.empty() : this.capabilities.getCapability(capability);
    }

    @Override
    public <T> void addVolatileCapability(Capability<T> capability, LazyOptional<T> value) {
        this.volatileCapabilities.put(capability, value);
    }

    @Override
    public void removeVolatileCapability(Capability<?> capability) {
        this.volatileCapabilities.remove(capability);
    }

    protected int getDefaultUpdateInterval() {
        return GeneralConfig.defaultPartUpdateFreq;
    }
}

